class treap:
    def __init__(self, s):
        n = 1
        while n < len(s):
            n *= 2
        self.g = [(0, 0) for _ in range(2*n-1)]
        for i in range(len(s)):
            if s[i] == "(":
                self.g[n-1+i] = (0, 1)
            else:
                self.g[n-1+i] = (-1, -1)
        for i in range(n-2, -1, -1):
            a, b = self.g[2*i+1]
            c, d = self.g[2*i+2]
            self.g[i] = (min(a, c+b), b+d)

    def find(self, v, l, r, l0, r0):
        if l > r0 or r < l0:
            return 0, 0
        if l >= l0 and r <= r0:
            return self.g[v]
        m = (r + l) // 2
        a, b = self.find(2*v+1, l, m, l0, r0)
        c, d = self.find(2*v+2, m+1, r, l0, r0)
        return min(a, c+b), b+d

n, k = map(int, input().split())
lg = 1
while lg < n:
    lg *= 2
s = input()
trip = treap(s)
for _ in range(k):
    l, r = map(int, input().split())
    l -= 1
    r -= 1
    a, b = trip.find(0, 0, lg-1, l, r)
    ans = b - 2 * a
    c = ans
    if b >= 0:
        for i in range(l, r+1):
            if s[i] == ")":
                c -= 1
            else:
                c += 3
            ans = min(ans, c)
    print(ans)